"""
HB_FastViewport V1.2

Last Modified: 6/28/2017
Works with CINEMA 4D R16.050 and up.

Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_FastViewport

Description-US: Changes several Settings to speed up the Viewport [CTRL: Disable also Materials, SHIFT: Disable also Expressions]

Usage:
Click once to turn on FastViewport mode. Click again to disable Fastviewport mode and restore old settings.
This Script changes following Settings:

- QuickShading
- EOGL: Shadows
- EOGL: Noises
- EOGL: Transparency
- EOGL: Posteffects
- Selected Wireframe
- ObjectHighlighting
- Camera Clipping
- Level of Detail
- Execution of Expressions off when SHIFT-Modifier is used.

- Use LayerColor [When CTRL is pressed]


Video Tutorial:
https://youtu.be/eEcAttV56kE?t=33m19s

ChangeLog:

6/28/2017 v1.2
- Linear Workflow does not get effected anymore
- CTRL:  disable Texture additional

1/1/2016 v1.1
- Minor Changes

6/11/2015 Release Version

"""

import c4d

def main():

    STORE_FAST=1035535
    drawBD = doc.GetActiveBaseDraw()
    Toggle_State=doc[c4d.DOCUMENT_LOD] # Get Toggle State from Level of Detail
    #Prefs = c4d.GetWorldContainerInstance()
    bc = c4d.BaseContainer()
    mysettings_bc=c4d.BaseContainer()
  
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):

        if Toggle_State== 1:
            
            #Save Settings
            mysettings_bc.SetData(1, drawBD[c4d.BASEDRAW_DATA_SDISPLAYACTIVE])
            mysettings_bc.SetData(2, drawBD[c4d.BASEDRAW_DATA_USE_LAYERCOLOR])
            mysettings_bc.SetData(3, drawBD[c4d.BASEDRAW_DATA_OUTLINE])
            mysettings_bc.SetData(4, drawBD[c4d.BASEDRAW_DATA_HQ_SHADOWS])
            mysettings_bc.SetData(5, drawBD[c4d.BASEDRAW_DATA_HQ_NOISES])
            mysettings_bc.SetData(6, drawBD[c4d.BASEDRAW_DATA_HQ_TRANSPARENCY])
            mysettings_bc.SetData(7, drawBD[c4d.BASEDRAW_DATA_HQ_POST_EFFECTS])
            mysettings_bc.SetData(9, drawBD[c4d.BASEDRAW_DATA_WIREFRAMESELECTION])
            mysettings_bc.SetData(10, drawBD[c4d.BASEDRAW_DATA_OUTLINE])
            mysettings_bc.SetData(11, drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHIGHLIGHTING])
            mysettings_bc.SetData(12, doc[c4d.DOCUMENT_CLIPPING_PRESET])
            mysettings_bc.SetData(13, drawBD[c4d.BASEDRAW_DATA_BOUNDINGBOXSELECTION])
            #mysettings_bc.SetData(15, Prefs[c4d.WPREF_OPENGL_ANTIALIAS])
        
        
            c4d.plugins.SetWorldPluginData(STORE_FAST, mysettings_bc)

            # Change Settings
            c4d.CallCommand(13859) # Low Detail
            if bc[c4d.BFM_INPUT_QUALIFIER] ==1: #SHIFT
                drawBD[c4d.BASEDRAW_DATA_USE_LAYERCOLOR]=True
                if (c4d.IsCommandChecked(13522)):
                    c4d.CallCommand(13522)
                    
            drawBD[c4d.BASEDRAW_DATA_SDISPLAYACTIVE]=2
            if bc[c4d.BFM_INPUT_QUALIFIER] ==2: #CTRL
                drawBD[c4d.BASEDRAW_DATA_USE_LAYERCOLOR]=True

            drawBD[c4d.BASEDRAW_DATA_OUTLINE]=True
            drawBD[c4d.BASEDRAW_DATA_HQ_SHADOWS]=False
            drawBD[c4d.BASEDRAW_DATA_HQ_NOISES]=False
            drawBD[c4d.BASEDRAW_DATA_HQ_TRANSPARENCY]=False
            drawBD[c4d.BASEDRAW_DATA_HQ_POST_EFFECTS]=False
            #drawBD[c4d.BASEDRAW_DATA_ENABLE_LWF]=False
            drawBD[c4d.BASEDRAW_DATA_WIREFRAMESELECTION]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHIGHLIGHTING]=False
            
            doc[c4d.DOCUMENT_CLIPPING_PRESET]=0
            
            
            drawBD[c4d.BASEDRAW_DATA_BOUNDINGBOXSELECTION]=True
            c4d.EventAdd()
            return

        # if Toggle is on Restore save Settings
        
        if Toggle_State  == 0.25:

            mysettings_bc=c4d.BaseContainer()

            c4d.CallCommand(13861) # High
            
            DISPLAYbc = c4d.plugins.GetWorldPluginData(STORE_FAST)
            #Prefs[c4d.WPREF_OPENGL_ANTIALIAS]=DISPLAYbc.GetData(15)
            #c4d.EventAdd()
            drawBD[c4d.BASEDRAW_DATA_SDISPLAYACTIVE]=DISPLAYbc.GetData(1)
            drawBD[c4d.BASEDRAW_DATA_USE_LAYERCOLOR]=DISPLAYbc.GetData(2)
            drawBD[c4d.BASEDRAW_DATA_OUTLINE]=DISPLAYbc.GetData(3)
            drawBD[c4d.BASEDRAW_DATA_HQ_SHADOWS]=DISPLAYbc.GetData(4)
            drawBD[c4d.BASEDRAW_DATA_HQ_NOISES]=DISPLAYbc.GetData(5)
            drawBD[c4d.BASEDRAW_DATA_HQ_TRANSPARENCY]=DISPLAYbc.GetData(6)
            drawBD[c4d.BASEDRAW_DATA_HQ_POST_EFFECTS]=DISPLAYbc.GetData(7)
            #drawBD[c4d.BASEDRAW_DATA_ENABLE_LWF]=DISPLAYbc.GetData(8)
            drawBD[c4d.BASEDRAW_DATA_WIREFRAMESELECTION]=DISPLAYbc.GetData(9)
            drawBD[c4d.BASEDRAW_DATA_OUTLINE]=DISPLAYbc.GetData(10)
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHIGHLIGHTING]=DISPLAYbc.GetData(11)
            doc[c4d.DOCUMENT_CLIPPING_PRESET]=DISPLAYbc.GetData(12)
            drawBD[c4d.BASEDRAW_DATA_BOUNDINGBOXSELECTION]=DISPLAYbc.GetData(13)
            if not (c4d.IsCommandChecked(13522)):
                c4d.CallCommand(13522) # Use Expressions

        c4d.EventAdd()
            
    
    
if __name__=='__main__':
    main()
